/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.core;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.FPSLogger;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.codedisaster.steamworks.SteamAPI;
import com.esotericsoftware.spine.SkeletonRendererDebug;
import com.megacrit.cardcrawl.audio.MusicMaster;
import com.megacrit.cardcrawl.audio.SoundMaster;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardSave;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.characters.Crowbot;
import com.megacrit.cardcrawl.characters.Ironclad;
import com.megacrit.cardcrawl.characters.TheSilent;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.EnergyManager;
import com.megacrit.cardcrawl.core.ExceptionHandler;
import com.megacrit.cardcrawl.core.GameCursor;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.daily.DailyMods;
import com.megacrit.cardcrawl.daily.TimeHelper;
import com.megacrit.cardcrawl.daily.TimeLookup;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.dungeons.Exordium;
import com.megacrit.cardcrawl.dungeons.TheBeyond;
import com.megacrit.cardcrawl.dungeons.TheCity;
import com.megacrit.cardcrawl.helpers.CardHelper;
import com.megacrit.cardcrawl.helpers.CardLibrary;
import com.megacrit.cardcrawl.helpers.DrawMaster;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.GameDictionary;
import com.megacrit.cardcrawl.helpers.GameTips;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.ModHelper;
import com.megacrit.cardcrawl.helpers.MonsterHelper;
import com.megacrit.cardcrawl.helpers.PotionHelper;
import com.megacrit.cardcrawl.helpers.Prefs;
import com.megacrit.cardcrawl.helpers.RelicLibrary;
import com.megacrit.cardcrawl.helpers.SaveHelper;
import com.megacrit.cardcrawl.helpers.ScreenShake;
import com.megacrit.cardcrawl.helpers.ShaderHelper;
import com.megacrit.cardcrawl.helpers.TipHelper;
import com.megacrit.cardcrawl.helpers.TipTracker;
import com.megacrit.cardcrawl.localization.LocalizedStrings;
import com.megacrit.cardcrawl.metrics.LeaderboardPoster;
import com.megacrit.cardcrawl.metrics.MetricData;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.potions.AbstractPotion;
import com.megacrit.cardcrawl.potions.PotionPlaceholder;
import com.megacrit.cardcrawl.powers.AbstractPower;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.relics.BottledFlame;
import com.megacrit.cardcrawl.relics.BottledLightning;
import com.megacrit.cardcrawl.relics.BottledTornado;
import com.megacrit.cardcrawl.rewards.RewardSave;
import com.megacrit.cardcrawl.rooms.MonsterRoomBoss;
import com.megacrit.cardcrawl.screens.DeathScreen;
import com.megacrit.cardcrawl.screens.DungeonTransitionScreen;
import com.megacrit.cardcrawl.screens.SingleCardViewPopup;
import com.megacrit.cardcrawl.screens.SingleRelicViewPopup;
import com.megacrit.cardcrawl.screens.mainMenu.MainMenuScreen;
import com.megacrit.cardcrawl.screens.mainMenu.MenuButton;
import com.megacrit.cardcrawl.screens.saveAndContinue.SaveAndContinue;
import com.megacrit.cardcrawl.screens.saveAndContinue.SaveFile;
import com.megacrit.cardcrawl.screens.splash.SplashScreen;
import com.megacrit.cardcrawl.screens.trial.AbstractTrial;
import com.megacrit.cardcrawl.shop.ShopScreen;
import com.megacrit.cardcrawl.steam.SteamSaveSync;
import com.megacrit.cardcrawl.ui.buttons.CancelButton;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CardCrawlGame
implements ApplicationListener {
    public static String VERSION_NUM = "[EARLY_ACCESS_011] (01-11-2018)";
    public static String TRUE_VERSION_NUM = "2018-01-11-PROD1";
    private OrthographicCamera camera;
    public static FitViewport viewport;
    public static PolygonSpriteBatch psb;
    private SpriteBatch sb;
    public static GameCursor cursor;
    public static boolean isPopupOpen;
    public static int popupMX;
    public static int popupMY;
    public static ScreenShake screenShake;
    public static AbstractDungeon dungeon;
    public static MainMenuScreen mainMenuScreen;
    public static SplashScreen splashScreen;
    public static DungeonTransitionScreen dungeonTransitionScreen;
    public static CancelButton cancelButton;
    public static MusicMaster music;
    public static SoundMaster sound;
    public static GameTips tips;
    public static SingleCardViewPopup cardPopup;
    public static SingleRelicViewPopup relicPopup;
    private FPSLogger fpsLogger = new FPSLogger();
    public boolean prevDebugKeyDown = false;
    public static String nextDungeon;
    public static GameMode mode;
    public static boolean startOver;
    private static boolean queueCredits;
    public static boolean fastMode;
    public static AbstractPlayer.PlayerClass chosenCharacter;
    public static boolean loadingSave;
    public SaveFile saveFile = null;
    public static String playerName;
    public static String alias;
    public static boolean ftuePopupShown;
    public static Prefs playerPref;
    public static Prefs helpPref;
    public static int monstersSlain;
    public static int elitesSlain;
    public static SkeletonRendererDebug debugRenderer;
    public static TimeLookup myRunnable;
    public static AbstractTrial trial;
    private static Color screenColor;
    private static float screenTimer;
    private static float screenTime;
    private static boolean fadeIn;
    public static MetricData metricData;
    public static LocalizedStrings languagePack;
    private boolean displayCursor = true;
    private ArrayList<String> debugString = new ArrayList();
    private float debugTimer;
    public static String preferenceDir;
    private static final Logger logger;

    public CardCrawlGame(String prefDir) {
        preferenceDir = prefDir;
    }

    @Override
    public void create() {
        if (Settings.isBeta) {
            VERSION_NUM = VERSION_NUM + " BETA";
        }
        logger.info("VERSION: " + TRUE_VERSION_NUM);
        logger.info("LIBGDX:  1.9.5");
        try {
            SteamSaveSync.initializeSteamApi();
            if (SteamAPI.isSteamRunning()) {
                SteamSaveSync.requestGlobalStats(365);
            }
            this.saveMigration();
            this.createBackups();
            playerPref = SaveHelper.getPrefs("STSPlayer");
            playerName = playerPref.getString("name", "");
            alias = playerPref.getString("alias", "");
            if (alias.equals("")) {
                alias = CardCrawlGame.generateRandomAlias();
                playerPref.putString("alias", alias);
                playerPref.flush();
            }
            ftuePopupShown = playerPref.getBoolean("ftuePopupShown", false);
            Settings.initialize();
            this.camera = new OrthographicCamera(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
            if (Settings.VERT_LETTERBOX_AMT != 0 || Settings.HORIZ_LETTERBOX_AMT != 0) {
                this.camera.position.set((float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f, 0.0f);
                this.camera.update();
                viewport = new FitViewport(Settings.WIDTH, (float)(Settings.M_H - Settings.HEIGHT / 2), this.camera);
            } else {
                this.camera.position.set(this.camera.viewportWidth / 2.0f, this.camera.viewportHeight / 2.0f, 0.0f);
                this.camera.update();
                viewport = new FitViewport(Settings.WIDTH, (float)Settings.HEIGHT, this.camera);
                viewport.apply();
            }
            languagePack = new LocalizedStrings();
            cardPopup = new SingleCardViewPopup();
            relicPopup = new SingleRelicViewPopup();
            if (Settings.IS_FULLSCREEN) {
                this.resize(Settings.M_W, Settings.M_H);
            }
            Gdx.graphics.setCursor(Gdx.graphics.newCursor(new Pixmap(Gdx.files.internal("images/blank.png")), 0, 0));
            this.sb = new SpriteBatch();
            psb = new PolygonSpriteBatch();
            music = new MusicMaster();
            sound = new SoundMaster();
            AbstractCreature.initialize();
            AbstractCard.initialize();
            GameDictionary.initialize();
            ImageMaster.initialize();
            AbstractPower.initialize();
            FontHelper.initialize();
            UnlockTracker.initialize();
            CardLibrary.initialize();
            RelicLibrary.initialize();
            InputHelper.initialize();
            PotionHelper.initialize();
            TipTracker.initialize();
            ModHelper.initialize();
            ShaderHelper.initializeShaders();
            UnlockTracker.retroactiveUnlock();
            cursor = new GameCursor();
            metricData = new MetricData();
            cancelButton = new CancelButton();
            tips = new GameTips();
            splashScreen = new SplashScreen();
            mode = GameMode.SPLASH;
            if (Settings.isDebug) {
                CardCrawlGame.splashScreen.isDone = true;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, logger);
            Gdx.app.exit();
        }
    }

    public void saveMigration() {
        if (!SaveHelper.saveExists()) {
            Preferences p = Gdx.app.getPreferences("STSPlayer");
            if (p.getString("name", "").equals("")) {
                System.out.println("New player, no migration.");
                return;
            }
            System.out.println("Migrating Save...");
            this.migrateHelper("STSPlayer");
            this.migrateHelper("STSUnlocks");
            this.migrateHelper("STSUnlockProgress");
            this.migrateHelper("STSTips");
            this.migrateHelper("STSSound");
            this.migrateHelper("STSSeenRelics");
            this.migrateHelper("STSSeenCards");
            this.migrateHelper("STSSeenBosses");
            this.migrateHelper("STSGameplaySettings");
            this.migrateHelper("STSDataVagabond");
            this.migrateHelper("STSDataTheSilent");
            this.migrateHelper("STSAchievements");
        } else {
            System.out.println("No migration");
        }
    }

    public void createBackups() {
        SaveHelper.getPrefs("STSPlayer").backupFlush();
        SaveHelper.getPrefs("STSUnlocks");
        SaveHelper.getPrefs("STSUnlockProgress").backupFlush();
        SaveHelper.getPrefs("STSTips").backupFlush();
        SaveHelper.getPrefs("STSSound").backupFlush();
        SaveHelper.getPrefs("STSSeenRelics").backupFlush();
        SaveHelper.getPrefs("STSSeenCards").backupFlush();
        SaveHelper.getPrefs("STSSeenBosses").backupFlush();
        SaveHelper.getPrefs("STSGameplaySettings").backupFlush();
        SaveHelper.getPrefs("STSDataVagabond").backupFlush();
        SaveHelper.getPrefs("STSDataTheSilent").backupFlush();
        SaveHelper.getPrefs("STSAchievements").backupFlush();
    }

    public void migrateHelper(String file) {
        Preferences p = Gdx.app.getPreferences(file);
        Prefs p2 = SaveHelper.getPrefs(file);
        Map<String, ?> map = p.get();
        for (Map.Entry<String, ?> c : map.entrySet()) {
            p2.putString(c.getKey(), p.getString(c.getKey()));
        }
        p2.flush();
    }

    @Override
    public void render() {
        try {
            if (!this.debugString.isEmpty()) {
                this.debugTimer -= Gdx.graphics.getDeltaTime();
                if (this.debugTimer < 0.0f) {
                    this.debugString.remove(0);
                    this.debugTimer = 3.0f;
                }
            }
            TimeHelper.update();
            if (Gdx.graphics.getDeltaTime() > 0.1f) {
                return;
            }
            this.update();
            this.sb.setProjectionMatrix(this.camera.combined);
            psb.setProjectionMatrix(this.camera.combined);
            Gdx.gl.glClear(16384);
            this.sb.begin();
            this.sb.setColor(Color.WHITE);
            switch (mode) {
                case SPLASH: {
                    splashScreen.render(this.sb);
                    break;
                }
                case CHAR_SELECT: {
                    mainMenuScreen.render(this.sb);
                    break;
                }
                case GAMEPLAY: {
                    if (dungeonTransitionScreen != null) {
                        dungeonTransitionScreen.render(this.sb);
                        break;
                    }
                    if (dungeon == null) break;
                    dungeon.render(this.sb);
                    break;
                }
                case DUNGEON_TRANSITION: {
                    break;
                }
                default: {
                    logger.info("Unknown Game Mode: " + mode.name());
                }
            }
            DrawMaster.draw(this.sb);
            if (CardCrawlGame.cardPopup.isOpen) {
                cardPopup.render(this.sb);
            }
            if (CardCrawlGame.relicPopup.isOpen) {
                relicPopup.render(this.sb);
            }
            TipHelper.render(this.sb);
            if (mode != GameMode.SPLASH) {
                this.renderBlackFadeScreen(this.sb);
                if (this.displayCursor) {
                    if (isPopupOpen && isPopupOpen) {
                        InputHelper.mX = popupMX;
                        InputHelper.mY = popupMY;
                    }
                    cursor.render(this.sb);
                }
            }
            int i = 0;
            for (String s : this.debugString) {
                FontHelper.renderFont(this.sb, FontHelper.tipBodyFont, s, 0.0f, 20.0f * Settings.scale + (float)i * 20.0f * Settings.scale, Color.GREEN);
                ++i;
            }
            if (Settings.HORIZ_LETTERBOX_AMT != 0) {
                this.sb.setColor(Color.BLACK);
                this.sb.draw(ImageMaster.WHITE_SQUARE_IMG, 0.0f, 0.0f, (float)Settings.WIDTH, (float)(-Settings.HORIZ_LETTERBOX_AMT));
                this.sb.draw(ImageMaster.WHITE_SQUARE_IMG, 0.0f, (float)Settings.HEIGHT, (float)Settings.WIDTH, (float)Settings.HORIZ_LETTERBOX_AMT);
            } else if (Settings.VERT_LETTERBOX_AMT != 0) {
                this.sb.setColor(Color.BLACK);
                this.sb.draw(ImageMaster.WHITE_SQUARE_IMG, 0.0f, 0.0f, (float)(-Settings.VERT_LETTERBOX_AMT), (float)Settings.HEIGHT);
                this.sb.draw(ImageMaster.WHITE_SQUARE_IMG, (float)Settings.WIDTH, 0.0f, (float)Settings.VERT_LETTERBOX_AMT, (float)Settings.HEIGHT);
            }
            this.sb.end();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, logger);
            Gdx.app.exit();
        }
    }

    private void renderBlackFadeScreen(SpriteBatch sb) {
        sb.setColor(screenColor);
        sb.draw(ImageMaster.WHITE_SQUARE_IMG, 0.0f, 0.0f, (float)Settings.WIDTH, (float)Settings.HEIGHT);
    }

    public void updateFade() {
        if (screenTimer != 0.0f) {
            if ((screenTimer -= Gdx.graphics.getDeltaTime()) < 0.0f) {
                screenTimer = 0.0f;
            }
            if (fadeIn) {
                CardCrawlGame.screenColor.a = Interpolation.fade.apply(1.0f, 0.0f, 1.0f - screenTimer / screenTime);
            } else {
                CardCrawlGame.screenColor.a = Interpolation.fade.apply(0.0f, 1.0f, 1.0f - screenTimer / screenTime);
                if (startOver && screenTimer == 0.0f) {
                    if (AbstractDungeon.scene != null) {
                        AbstractDungeon.scene.fadeOutAmbiance();
                    }
                    long startTime = System.currentTimeMillis();
                    AbstractDungeon.screen = AbstractDungeon.CurrentScreen.NONE;
                    AbstractDungeon.reset();
                    logger.info("Dungeon Reset: " + (System.currentTimeMillis() - startTime) + "ms");
                    startTime = System.currentTimeMillis();
                    ShopScreen.resetPurgeCost();
                    tips.initialize();
                    metricData.clearData();
                    logger.info("Shop Screen Rest, Tips Initialize, Metric Data Clear: " + (System.currentTimeMillis() - startTime) + "ms");
                    startTime = System.currentTimeMillis();
                    UnlockTracker.refresh();
                    logger.info("Unlock Tracker Refresh:  " + (System.currentTimeMillis() - startTime) + "ms");
                    startTime = System.currentTimeMillis();
                    mainMenuScreen = new MainMenuScreen();
                    CardCrawlGame.mainMenuScreen.bg.slideDownInstantly();
                    logger.info("New Main Menu Screen: " + (System.currentTimeMillis() - startTime) + "ms");
                    startTime = System.currentTimeMillis();
                    CardHelper.clear();
                    mode = GameMode.CHAR_SELECT;
                    nextDungeon = "Exordium";
                    dungeonTransitionScreen = new DungeonTransitionScreen("Exordium");
                    TipTracker.refresh();
                    logger.info("New Transition Screen, Tip Tracker Refresh: " + (System.currentTimeMillis() - startTime) + "ms");
                    startTime = System.currentTimeMillis();
                    CardCrawlGame.fadeIn(2.0f);
                    if (queueCredits) {
                        queueCredits = false;
                        for (MenuButton b : CardCrawlGame.mainMenuScreen.buttons) {
                            if (b.result != MenuButton.ClickResult.CREDITS) continue;
                            b.buttonEffect();
                        }
                        mainMenuScreen.hideMenuButtons();
                    }
                }
            }
        }
    }

    public static void fadeIn(float duration) {
        CardCrawlGame.screenColor.a = 1.0f;
        screenTime = duration;
        screenTimer = duration;
        fadeIn = true;
    }

    public static void fadeToBlack(float duration) {
        CardCrawlGame.screenColor.a = 0.0f;
        screenTime = duration;
        screenTimer = duration;
        fadeIn = false;
    }

    public static void startOver() {
        startOver = true;
        CardCrawlGame.fadeToBlack(2.0f);
    }

    public static void startOverButShowCredits() {
        startOver = true;
        queueCredits = true;
        CardCrawlGame.fadeToBlack(2.0f);
    }

    public static void startNewGame(AbstractPlayer.PlayerClass c) {
        sound.fadeOut(DeathScreen.STINGER_KEY, DeathScreen.STINGER_ID);
        if (AbstractDungeon.scene != null) {
            AbstractDungeon.scene.fadeOutAmbiance();
        }
        AbstractDungeon.screen = AbstractDungeon.CurrentScreen.NONE;
        monstersSlain = 0;
        elitesSlain = 0;
        AbstractDungeon.reset();
        ShopScreen.resetPurgeCost();
        tips.initialize();
        metricData.clearData();
        mainMenuScreen = new MainMenuScreen(false);
        CardCrawlGame.mainMenuScreen.bg.slideDownInstantly();
        CardHelper.clear();
        mode = GameMode.CHAR_SELECT;
        nextDungeon = "Exordium";
        dungeonTransitionScreen = new DungeonTransitionScreen("Exordium");
        UnlockTracker.refresh();
        TipTracker.refresh();
        chosenCharacter = c;
        AbstractDungeon.player = CardCrawlGame.createCharacter(c);
        for (AbstractCard i : AbstractDungeon.player.masterDeck.group) {
            if (i.rarity == AbstractCard.CardRarity.BASIC) continue;
            CardHelper.obtain(i.cardID, i.rarity, i.color);
        }
        mode = GameMode.GAMEPLAY;
        nextDungeon = "Exordium";
        dungeonTransitionScreen = new DungeonTransitionScreen("Exordium");
    }

    public void update() {
        cursor.update();
        screenShake.update(viewport);
        if (mode != GameMode.SPLASH) {
            this.updateFade();
        }
        music.update();
        sound.update();
        if (Gdx.input.isKeyJustPressed(34) && Settings.isDebug) {
            fastMode = !fastMode;
            logger.info("FAST MODE: " + fastMode);
            if (fastMode) {
                Settings.ACTION_DUR_FAST = 0.1f;
                Settings.ACTION_DUR_MED = 0.2f;
                Settings.ACTION_DUR_LONG = 0.3f;
                Settings.ACTION_DUR_XLONG = 0.5f;
            } else {
                Settings.ACTION_DUR_FAST = 0.33f;
                Settings.ACTION_DUR_MED = 0.5f;
                Settings.ACTION_DUR_LONG = 1.0f;
                Settings.ACTION_DUR_XLONG = 1.5f;
            }
        }
        if (Gdx.input.isKeyJustPressed(31) && Settings.isDebug) {
            this.displayCursor = !this.displayCursor;
        }
        InputHelper.updateFirst();
        if (CardCrawlGame.cardPopup.isOpen) {
            cardPopup.update();
        }
        if (CardCrawlGame.relicPopup.isOpen) {
            relicPopup.update();
        }
        if (isPopupOpen) {
            popupMX = InputHelper.mX;
            popupMY = InputHelper.mY;
            InputHelper.mX = -9999;
            InputHelper.mY = -9999;
        }
        switch (mode) {
            case SPLASH: {
                splashScreen.update();
                if (!CardCrawlGame.splashScreen.isDone) break;
                mode = GameMode.CHAR_SELECT;
                splashScreen = null;
                mainMenuScreen = new MainMenuScreen();
                break;
            }
            case CHAR_SELECT: {
                mainMenuScreen.update();
                if (CardCrawlGame.mainMenuScreen.fadedOut) {
                    AbstractDungeon.pathX = new ArrayList();
                    AbstractDungeon.pathY = new ArrayList();
                    if (!Settings.isTrial) {
                        if (loadingSave && !Settings.isDailyRun) {
                            AbstractDungeon.player = CardCrawlGame.createCharacter(chosenCharacter);
                            this.loadPlayerSave(AbstractDungeon.player);
                        } else {
                            AbstractDungeon.player = CardCrawlGame.createCharacter(chosenCharacter);
                        }
                        for (AbstractCard c : AbstractDungeon.player.masterDeck.group) {
                            if (c.rarity == AbstractCard.CardRarity.BASIC) continue;
                            CardHelper.obtain(c.cardID, c.rarity, c.color);
                        }
                        mode = GameMode.GAMEPLAY;
                        nextDungeon = "Exordium";
                        dungeonTransitionScreen = new DungeonTransitionScreen("Exordium");
                        if (loadingSave) {
                            CardCrawlGame.dungeonTransitionScreen.isComplete = true;
                            break;
                        }
                        monstersSlain = 0;
                        elitesSlain = 0;
                        break;
                    }
                    if (!Settings.isTrial) break;
                    Settings.trialName = CardCrawlGame.trial.name;
                    AbstractDungeon.player = CardCrawlGame.createCharacter(CardCrawlGame.trial.c);
                    AbstractDungeon.player.maxHealth = CardCrawlGame.trial.hp;
                    AbstractDungeon.player.currentHealth = CardCrawlGame.trial.hp;
                    AbstractDungeon.player.energy.energyMaster = CardCrawlGame.trial.energy;
                    AbstractDungeon.player.relics.clear();
                    int index = 0;
                    for (AbstractRelic r : CardCrawlGame.trial.relics) {
                        r.instantObtain(AbstractDungeon.player, index, false);
                        AbstractDungeon.relicsToRemoveOnStart.add(r.relicId);
                        ++index;
                    }
                    mode = GameMode.GAMEPLAY;
                    nextDungeon = "Exordium";
                    dungeonTransitionScreen = new DungeonTransitionScreen("Exordium");
                    break;
                }
                if (!Settings.isDebug) break;
                Settings.seed = new Random().nextLong();
                AbstractDungeon.generateSeeds();
                music.fadeOutBGM();
                AbstractDungeon.player = new Ironclad("MegaCrit", AbstractPlayer.PlayerClass.IRONCLAD);
                DailyMods.setModsFalse();
                mode = GameMode.GAMEPLAY;
                if (Settings.AMBIANCE_ON) {
                    sound.fadeOut("WIND", CardCrawlGame.mainMenuScreen.windId);
                }
                nextDungeon = "Exordium";
                dungeonTransitionScreen = new DungeonTransitionScreen("Exordium");
                break;
            }
            case GAMEPLAY: {
                if (dungeonTransitionScreen != null) {
                    dungeonTransitionScreen.update();
                    if (CardCrawlGame.dungeonTransitionScreen.isComplete) {
                        dungeonTransitionScreen = null;
                        if (loadingSave) {
                            this.getDungeon(this.saveFile.level_name, AbstractDungeon.player, this.saveFile);
                            this.loadPostCombat(this.saveFile);
                            if (!this.saveFile.post_combat) {
                                loadingSave = false;
                            }
                        } else {
                            this.getDungeon(nextDungeon, AbstractDungeon.player);
                            if (!nextDungeon.equals("Exordium") || Settings.isShowBuild || !TipTracker.tips.get("NEOW_SKIP").booleanValue()) {
                                AbstractDungeon.dungeonMapScreen.open(true);
                                TipTracker.neverShowAgain("NEOW_SKIP");
                            }
                        }
                    }
                } else if (dungeon != null) {
                    dungeon.update();
                } else {
                    logger.info("Eh-?");
                }
                if (dungeon == null || !AbstractDungeon.isDungeonBeaten || AbstractDungeon.fadeColor.a != 1.0f) break;
                dungeon = null;
                AbstractDungeon.scene.fadeOutAmbiance();
                dungeonTransitionScreen = new DungeonTransitionScreen(nextDungeon);
                break;
            }
            case DUNGEON_TRANSITION: {
                break;
            }
            default: {
                logger.info("Unknown Game Mode: " + mode.name());
            }
        }
        this.updateDebugSwitch();
        InputHelper.updateLast();
        if (Settings.isInfo) {
            this.fpsLogger.log();
        }
    }

    private void loadPostCombat(SaveFile saveFile) {
        if (saveFile.post_combat) {
            AbstractDungeon.getCurrRoom().isBattleOver = true;
            AbstractDungeon.overlayMenu.hideCombatPanels();
            AbstractDungeon.loading_post_combat = true;
            if (AbstractDungeon.getCurrRoom().monsters != null) {
                AbstractDungeon.getCurrRoom().monsters.monsters.clear();
            }
            block14: for (RewardSave i : saveFile.combat_rewards) {
                switch (i.type) {
                    case "CARD": {
                        continue block14;
                    }
                    case "GOLD": {
                        AbstractDungeon.getCurrRoom().addGoldToRewards(i.amount);
                        continue block14;
                    }
                    case "RELIC": {
                        AbstractDungeon.getCurrRoom().addRelicToRewards(RelicLibrary.getRelic(i.id).makeCopy());
                        continue block14;
                    }
                    case "POTION": {
                        AbstractDungeon.getCurrRoom().addPotionToRewards(PotionHelper.getPotion(i.id));
                        continue block14;
                    }
                    case "STOLEN_GOLD": {
                        AbstractDungeon.getCurrRoom().addStolenGoldToRewards(i.amount);
                        continue block14;
                    }
                }
                System.out.println("Loading unknown type: " + i.type);
            }
            if (AbstractDungeon.getCurrRoom() instanceof MonsterRoomBoss) {
                AbstractDungeon.scene.fadeInAmbiance();
                music.silenceTempBgmInstantly();
                music.silenceBGMInstantly();
                AbstractMonster.preloadBossStinger();
                AbstractMonster.playBossStinger();
            }
        }
    }

    private void loadPlayerSave(AbstractPlayer p) {
        this.saveFile = SaveAndContinue.loadSaveFile(p.chosenClass);
        p.currentHealth = this.saveFile.current_health;
        p.maxHealth = this.saveFile.max_health;
        p.displayGold = p.gold = this.saveFile.gold;
        p.masterHandSize = this.saveFile.hand_size;
        p.energy = new EnergyManager(this.saveFile.red + this.saveFile.green + this.saveFile.blue);
        monstersSlain = this.saveFile.monsters_killed;
        elitesSlain = this.saveFile.elites_killed;
        logger.info("Monsters Slain: " + monstersSlain);
        logger.info("Elites Slain: " + elitesSlain);
        p.masterDeck.clear();
        for (CardSave cardSave : this.saveFile.cards) {
            logger.info(cardSave.id + ", " + cardSave.upgrades);
            p.masterDeck.addToTop(CardLibrary.getCopy(cardSave.id, cardSave.upgrades));
        }
        p.relics.clear();
        int index = 0;
        for (String s : this.saveFile.relics) {
            RelicLibrary.getRelic(s).instantObtain(p, index, false);
            ++index;
        }
        index = 0;
        for (Integer i : this.saveFile.relic_counters) {
            p.relics.get(index).setCounter(i);
            p.relics.get(index).updateDescription(p.chosenClass);
            ++index;
        }
        index = 0;
        for (String s : this.saveFile.potions) {
            AbstractPotion potion = PotionHelper.getPotion(s);
            if (potion == null) {
                p.potions[index] = new PotionPlaceholder(index);
            } else {
                potion.isObtained = true;
                potion.isDone = true;
                potion.isAnimating = false;
                p.potions[index] = potion;
            }
            ++index;
        }
        if (this.saveFile.bottled_flame != null) {
            AbstractCard abstractCard = AbstractDungeon.player.masterDeck.findCardByName(this.saveFile.bottled_flame);
            abstractCard.inBottleFlame = true;
            ((BottledFlame)AbstractDungeon.player.getRelic((String)"Bottled Flame")).card = abstractCard;
            ((BottledFlame)AbstractDungeon.player.getRelic("Bottled Flame")).setDescriptionAfterLoading();
        }
        if (this.saveFile.bottled_lightning != null) {
            AbstractCard abstractCard = AbstractDungeon.player.masterDeck.findCardByName(this.saveFile.bottled_lightning);
            abstractCard.inBottleLightning = true;
            ((BottledLightning)AbstractDungeon.player.getRelic((String)"Bottled Lightning")).card = abstractCard;
            ((BottledLightning)AbstractDungeon.player.getRelic("Bottled Lightning")).setDescriptionAfterLoading();
        }
        if (this.saveFile.bottled_tornado != null) {
            AbstractCard abstractCard = AbstractDungeon.player.masterDeck.findCardByName(this.saveFile.bottled_tornado);
            abstractCard.inBottleTornado = true;
            ((BottledTornado)AbstractDungeon.player.getRelic((String)"Bottled Tornado")).card = abstractCard;
            ((BottledTornado)AbstractDungeon.player.getRelic("Bottled Tornado")).setDescriptionAfterLoading();
        }
        metricData.clearData();
        CardCrawlGame.metricData.campfire_rested = this.saveFile.metric_campfire_rested;
        CardCrawlGame.metricData.campfire_upgraded = this.saveFile.metric_campfire_upgraded;
        CardCrawlGame.metricData.campfire_rituals = this.saveFile.metric_campfire_rituals;
        CardCrawlGame.metricData.campfire_meditates = this.saveFile.metric_campfire_meditates;
        CardCrawlGame.metricData.purchased_purges = this.saveFile.metric_purchased_purges;
        CardCrawlGame.metricData.potions_floor_spawned = this.saveFile.metric_potions_floor_spawned;
        CardCrawlGame.metricData.current_hp_per_floor = this.saveFile.metric_current_hp_per_floor;
        CardCrawlGame.metricData.max_hp_per_floor = this.saveFile.metric_max_hp_per_floor;
        CardCrawlGame.metricData.gold_per_floor = this.saveFile.metric_gold_per_floor;
        CardCrawlGame.metricData.path_per_floor = this.saveFile.metric_path_per_floor;
        CardCrawlGame.metricData.path_taken = this.saveFile.metric_path_taken;
        CardCrawlGame.metricData.items_purchased = this.saveFile.metric_items_purchased;
        CardCrawlGame.metricData.items_purged = this.saveFile.metric_items_purged;
        CardCrawlGame.metricData.card_choices = this.saveFile.metric_card_choices;
        CardCrawlGame.metricData.event_choices = this.saveFile.metric_event_choices;
        CardCrawlGame.metricData.damage_taken = this.saveFile.metric_damage_taken;
    }

    public static void uploadCrashLog(Exception e) {
        logger.info("Uploading crash log data");
        if (Settings.UPLOAD_DATA) {
            LeaderboardPoster poster = new LeaderboardPoster();
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            poster.setValues(LeaderboardPoster.LeaderboardDataType.CRASH_DATA, exceptionAsString, null, null, false);
            Thread t = new Thread(poster);
            t.run();
        }
        try {
            Thread.sleep(2500L);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }

    private static AbstractPlayer createCharacter(AbstractPlayer.PlayerClass selection) {
        AbstractPlayer p = null;
        switch (selection) {
            case IRONCLAD: {
                p = new Ironclad(playerName, AbstractPlayer.PlayerClass.IRONCLAD);
                break;
            }
            case THE_SILENT: {
                p = new TheSilent(playerName, AbstractPlayer.PlayerClass.THE_SILENT);
                break;
            }
            case CROWBOT: {
                p = new Crowbot(playerName, AbstractPlayer.PlayerClass.CROWBOT);
            }
        }
        for (AbstractCard c : p.masterDeck.group) {
            UnlockTracker.markCardAsSeen(c.cardID);
        }
        return p;
    }

    private void updateDebugSwitch() {
        if (!Settings.isDev) {
            return;
        }
        if (Gdx.input.isKeyJustPressed(72) || Gdx.input.isKeyJustPressed(73)) {
            Settings.isDebug = !Settings.isDebug;
            return;
        }
        if (Gdx.input.isKeyJustPressed(71)) {
            Settings.isInfo = !Settings.isInfo;
            return;
        }
        if (Gdx.input.isKeyJustPressed(Input.Keys.valueOf("`"))) {
            RelicLibrary.uploadRelicData();
            CardLibrary.uploadCardData();
            MonsterHelper.uploadEnemyData();
            return;
        }
        if (Gdx.input.isKeyJustPressed(8) && Settings.isDebug) {
            Settings.hideTopBar = !Settings.hideTopBar;
            return;
        }
        if (Gdx.input.isKeyJustPressed(9) && Settings.isDebug) {
            Settings.hidePopupDetails = !Settings.hidePopupDetails;
            return;
        }
        if (Gdx.input.isKeyJustPressed(10) && Settings.isDebug) {
            Settings.hideRelics = !Settings.hideRelics;
            return;
        }
        if (Gdx.input.isKeyJustPressed(11) && Settings.isDebug) {
            Settings.hideLowerElements = !Settings.hideLowerElements;
            return;
        }
        if (Gdx.input.isKeyJustPressed(12) && Settings.isDebug) {
            Settings.hideCards = !Settings.hideCards;
            return;
        }
        if (Gdx.input.isKeyJustPressed(13) && Settings.isDebug) {
            Settings.hideEndTurn = !Settings.hideEndTurn;
            return;
        }
        if (Gdx.input.isKeyJustPressed(14) && Settings.isDebug) {
            Settings.hideCombatElements = !Settings.hideCombatElements;
        }
    }

    @Override
    public void resize(int width, int height) {
    }

    public AbstractDungeon getDungeon(String key, AbstractPlayer p) {
        switch (key) {
            case "Exordium": {
                ArrayList<String> emptyList = new ArrayList<String>();
                return new Exordium(p, emptyList);
            }
            case "TheCity": {
                return new TheCity(p, AbstractDungeon.specialOneTimeEventList);
            }
            case "TheBeyond": {
                return new TheBeyond(p, AbstractDungeon.specialOneTimeEventList);
            }
        }
        return null;
    }

    public AbstractDungeon getDungeon(String key, AbstractPlayer p, SaveFile saveFile) {
        switch (key) {
            case "Exordium": {
                return new Exordium(p, saveFile);
            }
            case "TheCity": {
                return new TheCity(p, saveFile);
            }
            case "TheBeyond": {
                return new TheBeyond(p, saveFile);
            }
        }
        return null;
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void dispose() {
        if (!Settings.isDemo) {
            // empty if block
        }
    }

    public static String generateRandomAlias() {
        String alphabet = "abcdefghijklmnopqrstuvwxyz0123456789";
        String retVal = "";
        for (int i = 0; i < 16; ++i) {
            retVal = retVal + alphabet.charAt(MathUtils.random(0, alphabet.length() - 1));
        }
        return retVal;
    }

    static {
        isPopupOpen = false;
        screenShake = new ScreenShake();
        mode = GameMode.CHAR_SELECT;
        startOver = false;
        queueCredits = false;
        fastMode = false;
        chosenCharacter = null;
        monstersSlain = 0;
        elitesSlain = 0;
        myRunnable = new TimeLookup();
        trial = null;
        screenColor = Color.BLACK.cpy();
        screenTimer = 2.0f;
        screenTime = 2.0f;
        fadeIn = true;
        preferenceDir = null;
        logger = LogManager.getLogger(CardCrawlGame.class.getName());
    }

    public static enum GameMode {
        CHAR_SELECT,
        GAMEPLAY,
        DUNGEON_TRANSITION,
        SPLASH;

    }
}

